/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.events.RSSwitchEvent;
import com.cisco.pt.ipc.events.RSSwitchEventListener;
import com.cisco.pt.ipc.ui.RSSwitch;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSwitchEventRegistry
extends IPCEventRegistry {
    protected Set<RSSwitchEventListener> globalListeners = new HashSet<RSSwitchEventListener>();
    protected Map<String, Set<RSSwitchEventListener>> specificObjectListeners = new HashMap<String, Set<RSSwitchEventListener>>();
    private static Log logger = LogFactory.getLog(RSSwitchEventRegistry.class);

    public RSSwitchEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "RSSwitch";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        RSSwitchEvent.ModeSwitched evt = null;
        if (!eventName.equalsIgnoreCase("modeSwitched")) {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        evt = new RSSwitchEvent.ModeSwitched(event);
        for (RSSwitchEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<RSSwitchEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (RSSwitchEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(RSSwitchEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("modeSwitched");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(RSSwitchEventListener listener, RSSwitch objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RSSwitchEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<RSSwitchEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "modeSwitched");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(RSSwitchEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("modeSwitched");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(RSSwitchEventListener listener, RSSwitch objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<RSSwitchEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "modeSwitched");
            specificListeners.remove(listener);
        }
    }

    public void addListener(RSSwitchEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(RSSwitchEventListener listener, RSSwitch objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(RSSwitchEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(RSSwitchEventListener listener, RSSwitch objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

